/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eapsetting.SsidC;
import com.tp_link.eap.domain.globalsetting.AccessSubnetGroup;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.bean.AccessControlRule;
import com.tp_link.eap.domain.globalsetting.bean.StringSubnet;
import com.tp_link.eap.domain.globalsetting.bean.Subnet;
import com.tp_link.eap.domain.globalsetting.bean.SubnetGroupDetail;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.record.SettingRecord;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.globalsetting.repo.SsidRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SubnetRepository;
import com.tp_link.eap.monitor.globalsetting.service.a;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.repo.site.SiteRepository;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.p.c;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="accessService")
public class AccessControlService
extends com.tp_link.eap.i.a.a<AccessSubnetGroup>
implements a {
    @Autowired
    private SubnetRepository b;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b c;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a d;
    @Autowired
    private SsidRepository e;
    @Autowired
    private SiteRepository f;
    private Logger g = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse refreshSubnetGroup(SubnetGroupDetail subnetGroupDetail) {
        if (subnetGroupDetail == null || com.tp_link.eap.util.a.e.a((String)subnetGroupDetail.getGroupName()) || subnetGroupDetail.getGroupName().length() > 32) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = "";
        boolean bl = false;
        String string2 = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            this.g.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        int n2 = 3;
        String string3 = subnetGroupDetail.getGroupId();
        Object object = com.tp_link.eap.b.b.a.l((String)string2);
        synchronized (object) {
            List<Ssid> list;
            AccessSubnetGroup accessSubnetGroup;
            Object object2;
            if (this.f.findBySiteName(string2) == null) {
                com.tp_link.eap.b.b.a.m((String)string2);
                this.g.warn("Site {} doesn't exist.", (Object)string2);
                return new OperationResponse(ResErrorCode.ck);
            }
            if (com.tp_link.eap.util.a.e.a((String)string3)) {
                object2 = new ArrayList();
                object2.add(new QueryFilter("site", (Object)string2, QueryFilter.FilterType.eq));
                long l2 = this.count((List<QueryFilter>)object2, null);
                if (l2 >= (long)com.tp_link.eap.util.e.eS.intValue()) {
                    return new OperationResponse(ResErrorCode.ay);
                }
                if (this.b.findByGroupNameAndSite(subnetGroupDetail.getGroupName(), string2) != null) {
                    return new OperationResponse(ResErrorCode.az, "Access Control rule '" + com.tp_link.eap.util.a.e.d((String)subnetGroupDetail.getGroupName()) + "' is already exist.", null);
                }
                n2 = 1;
                accessSubnetGroup = new AccessSubnetGroup(subnetGroupDetail.getGroupName(), subnetGroupDetail.getMode(), false);
                accessSubnetGroup.setSite(string2);
            } else {
                accessSubnetGroup = (AccessSubnetGroup)this.b.findOne((Serializable)((Object)subnetGroupDetail.getGroupId()));
                if (accessSubnetGroup == null) {
                    return new OperationResponse(ResErrorCode.aA);
                }
                object2 = this.a(subnetGroupDetail, accessSubnetGroup);
                if (!object2.success()) {
                    return object2;
                }
                string = accessSubnetGroup.getGroupName();
                accessSubnetGroup.setMode(subnetGroupDetail.getMode());
                accessSubnetGroup.setGroupName(subnetGroupDetail.getGroupName());
                if (!string.equals(accessSubnetGroup.getGroupName())) {
                    bl = true;
                }
            }
            object2 = new ArrayList();
            ArrayList<Subnet> arrayList = new ArrayList<Subnet>();
            OperationResponse operationResponse = this.a(subnetGroupDetail.getSubnets(), (List<Subnet>)object2);
            if (!operationResponse.success()) {
                return operationResponse;
            }
            accessSubnetGroup.setSubnets((List)object2);
            operationResponse = this.a(subnetGroupDetail.getExceptSubnets(), arrayList);
            if (!operationResponse.success()) {
                return operationResponse;
            }
            accessSubnetGroup.setExceptSubnets(arrayList);
            AccessSubnetGroup accessSubnetGroup2 = (AccessSubnetGroup)this.b.save(accessSubnetGroup);
            if (accessSubnetGroup2 == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            string3 = accessSubnetGroup2.getId();
            if (bl && !CollectionUtils.isEmpty(list = this.e.findByAccessControlRuleName(string))) {
                for (Ssid ssid : list) {
                    ssid.setAccessControlRuleName(accessSubnetGroup2.getGroupName());
                }
                this.e.save(list);
            }
        }
        this.a(string3, n2, com.tp_link.eap.d.b.a(), string);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public String addSubnetGroup(AccessSubnetGroup subnetGroup, boolean restore) {
        if (subnetGroup == null) {
            return null;
        }
        AccessSubnetGroup accessSubnetGroup = (AccessSubnetGroup)this.b.save(subnetGroup);
        if (accessSubnetGroup == null) {
            return null;
        }
        String string = accessSubnetGroup.getId();
        this.g.debug("selectGroup : " + string);
        return string;
    }

    @Override
    public SubnetGroupDetail getSubnetGroupDetail(String selectGroup) {
        AccessSubnetGroup accessSubnetGroup = (AccessSubnetGroup)this.b.findOne((Serializable)((Object)selectGroup));
        if (accessSubnetGroup != null) {
            List<StringSubnet> list = this.a(accessSubnetGroup.getSubnets());
            List<StringSubnet> list2 = this.a(accessSubnetGroup.getExceptSubnets());
            SubnetGroupDetail subnetGroupDetail = new SubnetGroupDetail(accessSubnetGroup.getId(), accessSubnetGroup.getGroupName(), accessSubnetGroup.getMode(), accessSubnetGroup.isSystemDefault());
            subnetGroupDetail.setSubnets(list);
            subnetGroupDetail.setExceptSubnets(list2);
            return subnetGroupDetail;
        }
        return null;
    }

    @Override
    public void deleteAllSubnetGroups() {
        this.b.deleteAll();
    }

    @Override
    public void addSubnetGroups(List<AccessSubnetGroup> subnetGroups) {
        if (!CollectionUtils.isEmpty(subnetGroups)) {
            for (AccessSubnetGroup accessSubnetGroup : subnetGroups) {
                accessSubnetGroup.setId(null);
            }
        }
        this.b.save(subnetGroups);
    }

    @Override
    public List<AccessSubnetGroup> getSubnetGroups() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll(new Sort(Sort.Direction.ASC, new String[]{"id"})));
    }

    @Override
    public List<AccessSubnetGroup> getSiteSubnets() {
        String string = com.tp_link.eap.d.b.a();
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("site", (Object)string, QueryFilter.FilterType.eq));
        return this.b.getByFilters(null, new QuerySort(QuerySort.SortDirection.asc, "id"), arrayList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse deleteSubnetGroup(String groupId) {
        AccessSubnetGroup accessSubnetGroup;
        if (com.tp_link.eap.util.a.e.a((String)groupId)) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.g.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.f.findBySiteName(string) == null) {
                com.tp_link.eap.b.b.a.m((String)string);
                this.g.warn("Site {} doesn't exist.", (Object)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            accessSubnetGroup = (AccessSubnetGroup)this.b.findOne((Serializable)((Object)groupId));
            if (accessSubnetGroup == null) {
                return new OperationResponse(ResErrorCode.aC);
            }
            if (accessSubnetGroup.isSystemDefault()) {
                return new OperationResponse(ResErrorCode.aD);
            }
            this.b.delete(accessSubnetGroup);
            List<Ssid> list = this.e.findByAccessControlRule(groupId);
            if (!CollectionUtils.isEmpty(list)) {
                for (Ssid ssid : list) {
                    ssid.setAccessControlRule("None");
                    ssid.setAccessControlRuleName("None");
                    ssid.setAccessControl(Boolean.valueOf(false));
                    this.e.save(ssid);
                }
            }
        }
        this.a(groupId, 2, com.tp_link.eap.d.b.a(), accessSubnetGroup.getGroupName());
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse a(SubnetGroupDetail subnetGroupDetail, AccessSubnetGroup accessSubnetGroup) {
        assert (subnetGroupDetail != null);
        assert (accessSubnetGroup != null);
        AccessSubnetGroup accessSubnetGroup2 = this.b.findByGroupNameAndSite(subnetGroupDetail.getGroupName(), com.tp_link.eap.d.b.a());
        if (accessSubnetGroup2 != null && !accessSubnetGroup2.getId().equals(accessSubnetGroup.getId())) {
            return new OperationResponse(ResErrorCode.az, "Access Control rule '" + subnetGroupDetail.getGroupName() + "' is already exist.", null);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse a(List<StringSubnet> list, List<Subnet> list2) {
        assert (!CollectionUtils.isEmpty(list));
        for (StringSubnet stringSubnet : list) {
            Subnet subnet = AccessControlService.a(stringSubnet.getIpMask());
            if (subnet == null) {
                return new OperationResponse(ResErrorCode.aB, (Object)String.format("Format of %s is illegal.", stringSubnet.getIpMask()));
            }
            list2.add(subnet);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private List<StringSubnet> a(List<Subnet> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<StringSubnet> arrayList = new ArrayList<StringSubnet>();
        for (Subnet subnet : list) {
            String string = subnet.getIpAddr() + "/" + subnet.getIpMask();
            arrayList.add(new StringSubnet(string));
        }
        return arrayList;
    }

    private static Subnet a(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            return null;
        }
        String string2 = stringArray[0];
        int n2 = Integer.parseInt(stringArray[1]);
        if (n2 < 1 || n2 > 32) {
            return null;
        }
        if (!com.tp_link.eap.util.p.c.a((String)string2)) {
            return null;
        }
        long l2 = com.tp_link.eap.util.a.e.b((String)string2);
        return new Subnet(com.tp_link.eap.util.a.e.a((long)(l2 &= (long)(-1 << 32 - n2))), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, int n2, String string2, String string3) {
        Object object;
        AccessControlRule accessControlRule = new AccessControlRule();
        accessControlRule.setRuleId(string);
        accessControlRule.setOperation(n2);
        accessControlRule.setOldRuleName(string3);
        if (n2 != 2) {
            object = (AccessSubnetGroup)this.b.findOne((Serializable)((Object)string));
            accessControlRule.setRuleName(object.getGroupName());
            accessControlRule.setMode(object.getMode());
            accessControlRule.setSubnets(object.getSubnets());
            accessControlRule.setExceptSubnets(object.getExceptSubnets());
        }
        if (!CollectionUtils.isEmpty((Collection)(object = string2 != null ? this.c.getSiteAdoptedAps(string2) : this.c.getAdoptAps()))) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Ap ap = (Ap)iterator.next();
                String string4 = ap.getMac();
                Object object3 = object2 = com.tp_link.eap.b.b.a.a((String)string4);
                synchronized (object3) {
                    SettingRecord settingRecord;
                    SettingRecord settingRecord2 = this.d.getRecord(string4, SettingRecord.SettingStatus.PENDING);
                    if (settingRecord2 == null) {
                        settingRecord2 = this.d.getRecord(string4, SettingRecord.SettingStatus.BACKUP);
                    }
                    EapConfigBody eapConfigBody = new EapConfigBody();
                    if (settingRecord2 == null) {
                        eapConfigBody.setAccessControlRules(Collections.singletonList(accessControlRule));
                        settingRecord = new SettingRecord(string4, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                        this.d.refreshRecord(settingRecord);
                    } else {
                        eapConfigBody = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)settingRecord2.getContent(), EapConfigBody.class);
                        if (eapConfigBody == null) {
                            eapConfigBody = new EapConfigBody();
                            eapConfigBody.setAccessControlRules(Collections.singletonList(accessControlRule));
                            settingRecord = new SettingRecord(string4, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                            this.d.refreshRecord(settingRecord);
                        } else {
                            this.a(eapConfigBody, (AccessControlRule)accessControlRule.clone());
                            this.a(string3, accessControlRule.getRuleName(), eapConfigBody);
                            settingRecord2.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                            this.d.refreshRecord(settingRecord2);
                        }
                    }
                }
            }
        }
    }

    private void a(EapConfigBody eapConfigBody, AccessControlRule accessControlRule) {
        List list = eapConfigBody.getAccessControlRules();
        if (CollectionUtils.isEmpty((Collection)list)) {
            eapConfigBody.setAccessControlRules(Collections.singletonList(accessControlRule));
        } else {
            boolean bl = false;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!((AccessControlRule)list.get(i2)).getRuleId().equals(accessControlRule.getRuleId())) continue;
                bl = true;
                if (((AccessControlRule)list.get(i2)).getOperation() == 1) {
                    if (accessControlRule.getOperation() == 3) {
                        accessControlRule.setOperation(1);
                        list.set(i2, accessControlRule);
                        break;
                    }
                    if (accessControlRule.getOperation() != 2) break;
                    list.remove(i2);
                    break;
                }
                if (((AccessControlRule)list.get(i2)).getOperation() != 3) break;
                if (accessControlRule.getOperation() != 3) {
                    this.g.error("add operation can not be after edit operation with same access rule.");
                    break;
                }
                accessControlRule.setOldRuleName(((AccessControlRule)list.get(i2)).getOldRuleName());
                list.set(i2, accessControlRule);
                break;
            }
            if (!bl) {
                list.add(accessControlRule);
            }
            if (list.isEmpty()) {
                eapConfigBody.setAccessControlRules(null);
            }
        }
    }

    private void a(String string, String string2, EapConfigBody eapConfigBody) {
        List list;
        if (string.equals(string2)) {
            this.g.debug("name was not changed, no need to merge.");
            return;
        }
        if (eapConfigBody.getSsid2G() != null && !CollectionUtils.isEmpty((Collection)(list = eapConfigBody.getSsid2G().getSsid()))) {
            for (SsidC ssidC : list) {
                if (!ssidC.getAccessControlRuleName().equals(string)) continue;
                this.g.debug("refresh bind rule name for ssid2g : " + ssidC.getSsidName() + " oldRuleName : " + string + "newRuleName : " + string2);
                ssidC.setAccessControlRuleName(string2);
            }
        }
        if (eapConfigBody.getSsid5G() != null && !CollectionUtils.isEmpty((Collection)(list = eapConfigBody.getSsid5G().getSsid()))) {
            for (SsidC ssidC : list) {
                if (!ssidC.getAccessControlRuleName().equals(string)) continue;
                this.g.debug("refresh bind rule name for ssid5g : " + ssidC.getSsidName() + " oldRuleName : " + string + "newRuleName : " + string2);
                ssidC.setAccessControlRuleName(string2);
            }
        }
    }

    public List<AccessSubnetGroup> getList(QueryPage queryPage) {
        return this.getList(queryPage, null);
    }

    public List<AccessSubnetGroup> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<AccessSubnetGroup> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<AccessSubnetGroup> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.countByFilters(filters, searchFilters);
    }

    @Override
    public AccessSubnetGroup getDefaultSubnetGroup() {
        return this.b.findBySystemDefault(true);
    }

    @Override
    public void deleteBySite() {
        String string = com.tp_link.eap.d.b.a();
        List<AccessSubnetGroup> list = this.b.findBySite(string);
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
    }

    @Override
    public OperationResponse getGridSubnetGroups(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.g.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("id");
            queryData.setSortOrder("asc");
        }
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        this.b(list);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getSubnetGroupList(ControlType controlType, JSONObject reqObj) {
        HashMap<String, List<AccessSubnetGroup>> hashMap = new HashMap<String, List<AccessSubnetGroup>>();
        List<AccessSubnetGroup> list = this.getSiteSubnets();
        this.b(list);
        hashMap.put("data", list);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getSubnetGroupDetail(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.g.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("groupId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return new OperationResponse(ResErrorCode.a, (Object)this.getSubnetGroupDetail(string));
    }

    @Override
    public OperationResponse addSubnetGroupDetail(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.g.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        SubnetGroupDetail subnetGroupDetail = (SubnetGroupDetail)com.tp_link.eap.util.a.b.a((String)jSONObject.toString(), SubnetGroupDetail.class);
        return this.refreshSubnetGroup(subnetGroupDetail);
    }

    @Override
    public OperationResponse modifySubnetGroupDetail(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.g.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        SubnetGroupDetail subnetGroupDetail = (SubnetGroupDetail)com.tp_link.eap.util.a.b.a((String)jSONObject.toString(), SubnetGroupDetail.class);
        return this.refreshSubnetGroup(subnetGroupDetail);
    }

    @Override
    public OperationResponse deleteSubnetGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.g.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("groupId");
        return this.deleteSubnetGroup(string);
    }

    private void b(List<AccessSubnetGroup> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (AccessSubnetGroup accessSubnetGroup : list) {
                accessSubnetGroup.setSubnets(null);
                accessSubnetGroup.setExceptSubnets(null);
            }
        }
    }
}

